<?php
include 'db.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

if($user_id) {
    $stmt = $conn->prepare("SELECT * FROM locations WHERE user_id = :user_id AND DATE(timestamp) = :date ORDER BY timestamp ASC");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':date', $date);
    $stmt->execute();
    $locations = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(["status" => "success", "data" => $locations]);
} else {
    echo json_encode(["status" => "error", "message" => "User ID required"]);
}
?>
